/**
 * <p>Contains an example exercise in which a neural network is trained to
 * recognize images of capital letters.</p>
 * 
 * <p>This example provides an interactive GUI which allows you to draw simple
 * 5x7 pixel images in black and white.  It also provides a database of images
 * corresponding to the capital letters in the Roman alphabet.  A simple
 * feed-forward neural network can be trained, using the back propagation
 * algorithm, to correctly recognize the character given the image.</p>
 * 
 * <p>You should start by familiarizing yourself with the code used in the
 * neural networks package.  Then fill in the following methods in this order:
 * </p>
 * <ul>
 * <li>{@link edu.uky.ai.ml.nn.NeuralNetwork#classify(edu.uky.ai.ml.nn.Database, double[])}</li>
 * <li>{@link edu.uky.ai.ml.nn.NeuralNetwork#getAccuracy(edu.uky.ai.ml.nn.Database)}</li>
 * <li>{@link edu.uky.ai.ml.Main#delta(edu.uky.ai.ml.nn.Neuron, double)}</li>
 * <li>{@link edu.uky.ai.ml.Main#delta(edu.uky.ai.ml.nn.Neuron, java.util.HashMap)}</li>
 * <li>{@link edu.uky.ai.ml.Main#backpropagate(edu.uky.ai.ml.nn.NeuralNetwork, edu.uky.ai.ml.nn.Example)}</li>
 * <li>{@link edu.uky.ai.ml.Main#learn(edu.uky.ai.ml.nn.NeuralNetwork, edu.uky.ai.ml.nn.Database)}</li>
 * </ul>
 */
package edu.uky.ai.ml;